// A base for traps that should respond to the TrapFlags
// and On/Off messages

//TrapForceRelock
//Use it like any trap ie Control Device from a Marker to the doors you want to force to relock. Doors locked down would drop all their PickCfg properties (no matter if locked or unlocked) and set their handles to their default locked position, even if one of the doors were picked but not entirely. Only key responding properties are unaffected. If a door requiring a key got picked opened and get relocked, picking it again won't be possible but the key will still work.


class TrapOnOffBase extends SqRootScript
{
	function ProceedOn()
	{
		return;
	}
	
	function ProceedOff()
	{
		return;
	}

	function OnTurnOn()
	{
		if((GetProperty("TrapFlags") | 4) != GetProperty("TrapFlags"))
		{
			if((GetProperty("TrapFlags") | 2) == GetProperty("TrapFlags"))
				ProceedOff();
			else
				ProceedOn();
		}
	}
	
	function OnTurnOff()
	{
		if((GetProperty("TrapFlags") | 8) != GetProperty("TrapFlags"))
		{
			if((GetProperty("TrapFlags") | 2) == GetProperty("TrapFlags"))
				ProceedOn();
			else
				ProceedOff();
		}
	}
}

class TrapForceRelock extends TrapOnOffBase
{
	function LockMe(activate)
	{
		foreach(l in Link.GetAll("ControlDevice",self))
		{
			local target = LinkDest(l);
			
			
			Property.SetSimple(target, "Locked", false);
			if(activate)
			{
				if(Property.Get(target, "Locked") && Property.Possessed(target,"PickCfg"))
					Property.Remove(target,"PickCfg");
				else
				{
					Property.SetSimple(target, "Locked", true);
					Property.Remove(target,"PickState");
					Property.Remove(target,"PickCfg");	
				}
			}
		}
	}

	function ProceedOn()
	{
		LockMe(true);
	}

	function ProceedOff()
	{
		LockMe(false);
	}
}