class BearTrap extends SqRootScript
{
	function setProperties(obj)
	{
		Property.Set(obj,"PhysAttr","Rest Axes",36);
		Property.Set(obj,"CfgTweqDelete","AnimC",2);
		Property.Set(obj,"CfgTweqDelete","Rate",30000);
		Property.Set(obj,"StTweqDelete","AnimS",1);
		Property.Set(obj,"FrobInfo","World Action",0);
	}

	function Arm()
	{
		if(GetData("BearTrapMode") > 2)
			return;
			
		if(IsDataSet("ArmingTimer"))
		{
			KillTimer(GetData("ArmingTimer"));
			ClearData("ArmingTimer");
		}
		SetData("BearTrapMode",3);
		if(!Object.HasMetaProperty(self,"MineSensePing"))
			Object.AddMetaProperty(self,"MineSensePing");
		if(!Object.HasMetaProperty(self,"ActiveMineLock"))
			Object.AddMetaProperty(self,"ActiveMineLock");
		SetProperty("Locked",true);
		SetProperty("FrobInfo","World Action",18);
	}
	
	function DisArm()
	{
		Sound.PlayEnvSchema(self,"Event StateChange, DirectionState Reverse",self,null,eEnvSoundLoc.kEnvSoundAtObjLoc);
		local new = Object.Create("BearTrap");
		Object.Teleport(new, vector(0), vector(0), self);
		Object.Destroy(self);
	}
	
	function Trigger(victim)
	{
		if(HasProperty("CfgTweqJoints"))
		{
			local v = GetProperty("CfgTweqJoints","    rate-low-high");
			v.x = 50;
			SetProperty("CfgTweqJoints","    rate-low-high",v);
			SetProperty("CfgTweqJoints","    rate-low-high2",v);
			SetProperty("StTweqJoints","AnimS",3);
			SetProperty("StTweqJoints","Joint1AnimS",3);
			SetProperty("StTweqJoints","Joint2AnimS",3);
		}
		Sound.PlayEnvSchema(self,"Event Activate",self,null,eEnvSoundLoc.kEnvSoundAtObjLoc);
		
		
		if (Object.Exists(victim) && !Object.HasMetaProperty(victim,"NoPingBack"))
		{
			ActReact.EndContact(self,victim);
			ActReact.BeginContact(self,victim);
			//DarkUI.TextMessage(Object.GetName(victim));
			if(Object.InheritsFrom(victim, "Creature"))
			{
				Physics.UnsubscribeMsg(self,ePhysScriptMsgType.kFellAsleepMsg);
				Physics.UnsubscribeMsg(self,ePhysScriptMsgType.kCollisionMsg);
				
				Property.Remove(self,"PhysType");
				Property.Remove(self,"PhysAttr");
				Property.Remove(self,"PhysDims");
				Property.Remove(self,"PhysControl");
				
				SetProperty("FrobInfo","World Action",0);
				if(Object.HasMetaProperty(self,"MineSensePing"))
					Object.RemoveMetaProperty(self,"MineSensePing");
				Object.AddMetaProperty(victim,"NoPingBack");
				
				if (! Link.AnyExist("AIWatchObj",victim,self))
					Link.Create("AIWatchObj",victim,self);
				local l = 0;
				if (! Link.AnyExist("DetailAttachement",self,victim))
					l = Link.Create("DetailAttachement",self,victim);
				
				LinkTools.LinkSetData(l,"joint",18);
				LinkTools.LinkSetData(l,"Type",2);
				
				return;
			}
		}
		if(!HasProperty("CfgTweqJoints"))
			DisArm();
		else
			SetData("BearTrapMode",2);
	}
	
	function OnBreakFree()
	{
		local o1 = Object.Create("JunkLever");
		Property.SetSimple(o1,"ModelName","Jo_BearTrapBrk1");
		local o2 = Object.Create("JunkLever");
		Property.SetSimple(o2,"ModelName","Jo_BearTrapBrk2");
		local o3 = Object.Create("JunkLever");
		Property.SetSimple(o3,"ModelName","Jo_BearTrapBrk3");
		setProperties(o1);
		setProperties(o2);
		setProperties(o3);
		
		Object.Teleport(o1,vector(0,0,0),vector(0),self);
		Object.Teleport(o2,vector(-1.5,0,1),vector(0),self);
		Object.Teleport(o3,vector(1.5,0,1),vector(0),self);
		Sound.PlayEnvSchema(self,"Event DeActivate",self,null,eEnvSoundLoc.kEnvSoundAtObjLoc);
		Object.Destroy(self);
	}

	function OnBeginScript()
	{
		if(!IsDataSet("BearTrapMode"))
			SetData("BearTrapMode",0);
		
		if(!IsDataSet("BearTrapSpeed"))
		{
			local v = GetProperty("CfgTweqJoints","    rate-low-high");
			SetData("BearTrapSpeed",v.x);
		}

		Physics.SubscribeMsg(self,ePhysScriptMsgType.kFellAsleepMsg);
		Physics.SubscribeMsg(self,ePhysScriptMsgType.kCollisionMsg);
	}
	
	function OnEndScript()
	{
		Physics.UnsubscribeMsg(self,ePhysScriptMsgType.kFellAsleepMsg);
		Physics.UnsubscribeMsg(self,ePhysScriptMsgType.kCollisionMsg)
	}
	
	function OnPhysCollision()
	{
		if(GetData("BearTrapMode") > 2)
		{
			local WhatHitMe = message().collObj;
			local fakeout = false;
			local selfvel = vector(0);
			if (Physics.HasPhysics(self))
				Physics.GetVelocity(self,selfvel)
			local selfmag = selfvel.Length();

			if (Object.Exists(WhatHitMe))
			{
				local hitmevel = vector(0);
				if (Physics.HasPhysics(WhatHitMe))
					Physics.GetVelocity(WhatHitMe,hitmevel)
				local hitmemag = hitmevel.Length();
				
				if ((selfmag < 10) && (hitmemag < 10))
					fakeout = true;
			}
			else
			{
				if(selfmag < 10) fakeout = true;
			}
			
			if(!fakeout)
				Trigger(WhatHitMe);
		}
	}
	
	function OnPhysFellAsleep()
	{
		if(GetData("BearTrapMode") < 2)
		{
			local arming = GetData("BearTrapMode")
			if ( (Link.AnyExist("~CulpableFor",self) && (!arming)) )
			{
				local played = Sound.PlayEnvSchema(self,"Event StateChange, DirectionState Forward",self,null,eEnvSoundLoc.kEnvSoundAtObjLoc);
				
				local t = SetOneShotTimer("Arm",6.0)					
				SetData("ArmingTimer",t);
				SetData("BearTrapMode",1);
				
				if(HasProperty("CfgTweqJoints"))
				{
					SetProperty("StTweqJoints","AnimS",1);
					SetProperty("StTweqJoints","Joint1AnimS",1);
					SetProperty("StTweqJoints","Joint2AnimS",1);
				}
				else
				{
					if(!played) Armed();
				}
			}
		}
	}
	
	function OnTweqComplete()
	{
		if(message().Type == eTweqType.kTweqTypeJoints)
		{
			SetProperty("StTweqJoints","AnimS",0);
			SetProperty("StTweqJoints","Joint1AnimS",0);
			SetProperty("StTweqJoints","Joint2AnimS",0);
			
			if(GetData("BearTrapMode") == 1)
				Arm();
			else if(GetData("BearTrapMode") == 2)
				DisArm();
		}
	}
	
	function OnSlain()
	{
		if(GetData("BearTrapMode") > 2 && Object.InheritsFrom(message().culprit, "Creature"))
			Trigger(message().culprit);
	}
	
	function OnSchemaDone()
	{
		if (GetData("BearTrapMode") == 1 && !HasProperty("CfgTweqJoints"))
			Arm();
	}
	
	function OnTimer()
	{
		if(message().name == "Arm") Arm();
		if(message().name == "DisArm") DisArm();
	}
	
	function OnFrobWorldEnd()
	{
		if(GetData("BearTrapMode") <= 2)
		{
			local arming = GetData("BearTrapMode")
			SetData("BearTrapMode",0);
			Sound.HaltSchema(self);
			if(arming && IsDataSet("ArmingTimer"))
			{
				KillTimer(GetData("ArmingTimer"));
				ClearData("ArmingTimer");
			}
			
			if(IsDataSet("BearTrapSpeed"))
			{
				local v = GetProperty("CfgTweqJoints","    rate-low-high");
				v.x = GetData("BearTrapSpeed");
				SetProperty("CfgTweqJoints","    rate-low-high",v);
				SetProperty("CfgTweqJoints","    rate-low-high2",v);
			}
			
			SetProperty("StTweqJoints","AnimS",0);
			SetProperty("StTweqJoints","Joint1AnimS",0);
			SetProperty("StTweqJoints","Joint2AnimS",0);
			SetProperty("JointPos","Joint 1",0);
			SetProperty("JointPos","Joint 2",0);
			
			if(Object.HasMetaProperty(self,"ActiveMineLock"))
				Object.RemoveMetaProperty(self,"ActiveMineLock");
		}
	}
	
	function OnPickStateChange()
	{
		if (message().currentstate == 8)
		{
			DisArm();
		}
	}
}